package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Teg_FL_door extends FrontDoor
{
	public Teg_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Teg front left door";

		value = 310;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.teg:0x000000DFr, "FL window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000DFr, "FL window", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000DAr, "L mirror", actcolor, optical, power );
		} else
		{
			float part_random = random();
			if ( part_random >= 0.66667 ) addPart( cars.cat_02.teg:0x000000EEr, "L mirror 3", actcolor, optical, power ); else
			if ( part_random >= 0.33333 ) addPart( cars.cat_02.teg:0x000000ECr, "L mirror 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000DAr, "L mirror", actcolor, optical, power );
		}
	}
}
